<?php
// تحميل مدير الترجمة والمعالجة غير المتزامنة
$translationManager = TranslationManager::getInstance();
$asyncProcessor = AsyncProcessor::getInstance();
$performanceMonitor = PerformanceMonitor::getInstance();

// تحديد لغة الأدمن
$adminLang = $langs[$admin] ?? 'ar';

// نصوص الترجمة للإدارة
$txt = [
    "ar" => [
        "1" => "✅ - تم إعادة شحن حسابك بـ مبلغ __point__",
        "2" => "تم سحب __point__ من حسابك",
        "3" => "تم حظرك من استخدام البوت",
        "4" => "تم الغاء حظرك من استخدام البوت",
        "5" => "اهلا وسهلا بك عزيزي الادمن",
        "6" => "رصيدك في موقع الارقام __balance__\n\nاوامر الادمن",
        "7" => "قم بارسال ايدي العضو",
        "8" => "لا يوجد مستخدم بهذا الايدي",
        "9" => "قم بارسال الرصيد الذي تريد اضافته",
        "10" => "قم بارسال الرصيد الذي تريد سحبه من العضو",
        "11" => "تم التحويل بنجاح",
        "12" => "تم السحب بنجاح",
        "13" => "يجب ان ترسل رقم اكبر من الصفر",
        "14" => "تم حظر العضو بنجاح",
        "15" => "تم الغاء الحظر بنجاح",
        "16" => "قم بارسال الاسم في سطر واليوزر في السطر الثاني",
        "17" => "تمت اضافة الوكيل بنجاح",
        "18" => "قم بارسال الاسم في سطر واليوزر في السطر الثاني",
        "19" => "اختار الوكيل الذي تريد حذفة",
        "20" => "تم الحذف بنجاح",
        "21" => "جميع الوكلاء",
        "22" => "الدول المتاحة\n",
        "23" => "لا توجد قائمة تاليه",
        "24" => "لا توجد قائمة سابقة",
        "25" => "قم بارسال سعر البيع",
        "26" => "تمت اضافة الدولة بنجاح",
        "27" => "قم بارسال قيمة رقمية اكبر من الصفر",
        "28" => "قم باختيار الدولة التي تريد خذفها",
        "29" => "تم الحذف بنجاح",
        "30" => "عدد عمليات الشراء __trybuy__\nعدد العمليات الناجحة __buy__",
        "31" => "احصائيات النظام",
        "32" => "الطلبات البطيئة",
        "33" => "إحصائيات التخزين المؤقت",
        "34" => "إحصائيات الملفات"
    ],
    "en" => [
        "1" => "✅ - Your account has been recharged with __point__",
        "2" => "__point__ has been deducted from your account",
        "3" => "You have been banned from using the bot",
        "4" => "You have been unbanned from using the bot",
        "5" => "Welcome, dear admin",
        "6" => "Your balance in the numbers site: __balance__\n\nAdmin commands",
        "7" => "Send the user ID",
        "8" => "No user with this ID",
        "9" => "Send the balance you want to add",
        "10" => "Send the balance you want to withdraw from the user",
        "11" => "Transfer completed successfully",
        "12" => "Withdrawal completed successfully",
        "13" => "You must send a number greater than zero",
        "14" => "User banned successfully",
        "15" => "User unbanned successfully",
        "16" => "Send the name in one line and the username in the second line",
        "17" => "Agent added successfully",
        "18" => "Send the name in one line and the username in the second line",
        "19" => "Choose the agent you want to delete",
        "20" => "Deleted successfully",
        "21" => "All agents",
        "22" => "Available countries\n",
        "23" => "No next list available",
        "24" => "No previous list available",
        "25" => "Send the selling price",
        "26" => "Country added successfully",
        "27" => "Send a numeric value greater than zero",
        "28" => "Choose the country you want to delete",
        "29" => "Deleted successfully",
        "30" => "Purchase attempts: __trybuy__\nSuccessful operations: __buy__",
        "31" => "System Statistics",
        "32" => "Slow Requests",
        "33" => "Cache Statistics",
        "34" => "File Statistics"
    ]
];

// استخدام المعالجة غير المتزامنة لحفظ البيانات
function saveDataAsync($type, $data) {
    global $asyncProcessor;
    return $asyncProcessor->addTask($type, $data, 'high');
}

// زر الرجوع مع الترجمة
$backText = $adminLang == 'ar' ? "رجوع" : "Back";
$back = mkBtn([[$backText => "back"]]);

if ($text == "/start" || $data == "back") {
    $btn = mkBtn([
        [
            "اضافة رصيد" => "addPoint",
            "سحب رصيد" => "takePoint"
        ],
        [
            "حظر عضو" => "ban",
            "الغاء الحظر" => "unban"
        ],
        [
            "اضافة وكيل" => "addWk",
            "حذف وكيل" => "remWk"
        ],
        [
            "الوكلاء" => "wk",
        ],
        [
            "اضافة دولة" => "addContry",
            "حذف دولة" => "remContry"
        ],
        [
            "الاحصائيات" => "stats"
        ],
        [
            "أداء النظام" => "performance"
        ]
    ]);
    
    $info[$id]['action'] = "";
    DataManager::save("storage/data/info.json", $info);
    
    $tx = $translationManager->get("5", $adminLang) . "\n" . 
          $translationManager->get("6", $adminLang, ["__balance__" => $balance]);
    
    if ($text) {
        send($tx, $btn);
    } else {
        edit($tx, $btn);
    }
} else if ($data == "addPoint") {
    $tx = $translationManager->get("7", $adminLang);
    $info[$id]['action'] = "addPointId";
    DataManager::save("storage/data/info.json", $info);
    edit($tx, $back);
} else if ($text && ($info[$id]['action'] == "addPointId")) {
    if (!isset($points[$text])) {
        $tx = $translationManager->get("8", $adminLang);
        send($tx, $back);
    } else {
        $info[$id]['idPoint'] = $text;
        $info[$id]['action'] = "addPoint";
        DataManager::save("storage/data/info.json", $info);
        $tx = $translationManager->get("9", $adminLang);
        send($tx, $back);
    }
} else if ($text && $info[$id]['action'] == "addPoint") {
    if (is_numeric($text) && $text > 0) {
        $points[$info[$id]['idPoint']] += ($text);
        saveDataAsync('save_points', [
            'id' => $info[$id]['idPoint'],
            'points' => $points[$info[$id]['idPoint']]
        ]);
        
        $tx = $translationManager->get("11", $adminLang);
        send($tx, $back);
        
        $userLang = $langs[$info[$id]['idPoint']] ?? 'ar';
        $userTx = $translationManager->get("1", $userLang, ["__point__" => $text]);
        send($userTx, null, $info[$id]['idPoint']);
        
        $info[$id]['idPoint'] = "";
        $info[$id]['action'] = "";
        DataManager::save("storage/data/info.json", $info);
    } else {
        $tx = $translationManager->get("13", $adminLang);
        send($tx, $back);
    }
} else if ($data == "takePoint") {
    $tx = $translationManager->get("7", $adminLang);
    $info[$id]['action'] = "takePointId";
    DataManager::save("storage/data/info.json", $info);
    edit($tx, $back);
} else if ($text && ($info[$id]['action'] == "takePointId")) {
    if (!isset($points[$text])) {
        $tx = $translationManager->get("8", $adminLang);
        send($tx, $back);
    } else {
        $info[$id]['idPoint'] = $text;
        $info[$id]['action'] = "takePoint";
        DataManager::save("storage/data/info.json", $info);
        $tx = $translationManager->get("10", $adminLang);
        send($tx, $back);
    }
} else if ($text && $info[$id]['action'] == "takePoint") {
    if (is_numeric($text) && $text > 0) {
        $points[$info[$id]['idPoint']] -= ($text);
        saveDataAsync('save_points', [
            'id' => $info[$id]['idPoint'],
            'points' => $points[$info[$id]['idPoint']]
        ]);
        
        $tx = $translationManager->get("12", $adminLang);
        send($tx, $back);
        
        $userLang = $langs[$info[$id]['idPoint']] ?? 'ar';
        $userTx = $translationManager->get("2", $userLang, ["__point__" => $text]);
        send($userTx, null, $info[$id]['idPoint']);
        
        $info[$id]['idPoint'] = "";
        $info[$id]['action'] = "";
        DataManager::save("storage/data/info.json", $info);
    } else {
        $tx = $translationManager->get("13", $adminLang);
        send($tx, $back);
    }
} else if ($data == "ban") {
    $tx = $translationManager->get("7", $adminLang);
    $info[$id]['action'] = "ban";
    DataManager::save("storage/data/info.json", $info);
    edit($tx, $back);
} else if ($text && $info[$id]['action'] == "ban") {
    $tx = $translationManager->get("14", $adminLang);
    $info[$id]['action'] = "";
    DataManager::save("storage/data/info.json", $info);
    
    $bans[$text] = $text;
    DataManager::save("storage/data/bans.json", $bans);
    
    send($tx, $back);
    
    $userLang = $langs[$text] ?? 'ar';
    $userTx = $translationManager->get("3", $userLang);
    send($userTx, null, $text);
} else if ($data == "unban") {
    $tx = $translationManager->get("7", $adminLang);
    $info[$id]['action'] = "unban";
    DataManager::save("storage/data/info.json", $info);
    edit($tx, $back);
} else if ($text && $info[$id]['action'] == "unban") {
    $tx = $translationManager->get("15", $adminLang);
    $info[$id]['action'] = "";
    DataManager::save("storage/data/info.json", $info);
    
    $bans[$text] = null;
    unset($bans[$text]);
    DataManager::save("storage/data/bans.json", $bans);
    
    send($tx, $back);
    
    $userLang = $langs[$text] ?? 'ar';
    $userTx = $translationManager->get("4", $userLang);
    send($userTx, null, $text);
} else if ($data == "addWk") {
    $tx = $translationManager->get("16", $adminLang);
    $info[$id]['action'] = "addWk";
    DataManager::save("storage/data/info.json", $info);
    edit($tx, $back);
} else if ($text && $info[$id]['action'] == "addWk") {
    $extx = explode("\n", $text);
    if (count($extx) == 2) {
        $info['bot']['wk'][] = [
            "name" => $extx[0],
            "user" => $extx[1],
        ];
        $info[$id]['action'] = "";
        DataManager::save("storage/data/info.json", $info);
        $tx = $translationManager->get("17", $adminLang);
        send($tx, $back);
    } else {
        $tx = $translationManager->get("18", $adminLang);
        send($tx, $back);
    }
} else if ($data == "remWk") {
    $btn = [];
    $btn[] = [
        ($adminLang == 'ar' ? "الاسم" : "Name") => "ntn",
        ($adminLang == 'ar' ? "اليوزر" : "Username") => "ntn"
    ];
    
    foreach ($info['bot']['wk'] as $k => $v) {
        $d = "remWk-{$k}";
        $btn[] = [
            $v['name'] ?? "" => $d,
            $v['user'] ?? "" => $d,
        ];
    }
    $btn[] = [$backText => "back"];
    
    $tx = $translationManager->get("19", $adminLang);
    edit($tx, mkBtn($btn));
} else if (preg_match("/remWk\-/", $data)) {
    $wkIndex = explode("-", $data)[1];
    $info['bot']['wk'][$wkIndex] = null;
    unset($info['bot']['wk'][$wkIndex]);
    $info['bot']['wk'] = array_values($info['bot']['wk']); // إعادة ترتيب المفاتيح
    DataManager::save("storage/data/info.json", $info);
    
    $tx = $translationManager->get("20", $adminLang);
    edit($tx, $back);
} else if ($data == "wk") {
    $btn = [];
    $btn[] = [
        ($adminLang == 'ar' ? "الاسم" : "Name") => "ntn",
        ($adminLang == 'ar' ? "اليوزر" : "Username") => "ntn"
    ];
    
    foreach ($info['bot']['wk'] as $v) {
        $btn[] = [
            $v['name'] ?? "" => "ntn",
            $v['user'] ?? "" => "ntn",
        ];
    }
    $btn[] = [$backText => "back"];
    
    $tx = $translationManager->get("21", $adminLang);
    edit($tx, mkBtn($btn));
} else if ($data == "addContry" || $exData[0] == 'next' || $exData[0] == 'before') {
    $get = $api->getCountries();
    $tx = $translationManager->get("22", $adminLang);
    
    if ($data == "addContry") {
        $start = 0;
    } else if ($exData[0] == 'next') {
        $start = $exData[1];
        if ($start > count($get)) {
            bot('answercallbackquery', [
                'callback_query_id' => $update->callback_query->id,
                'show_alert' => true,
                'text' => $translationManager->get("23", $adminLang),
            ]);
            exit;
        }
    } else if ($exData[0] == 'before') {
        $start = $exData[1];
        if ($start >= 30) {
            $start -= 30;
        } else if ($start > 0) {
            $start = 0;
        } else {
            bot('answercallbackquery', [
                'callback_query_id' => $update->callback_query->id,
                'show_alert' => true,
                'text' => $translationManager->get("24", $adminLang),
            ]);
            exit;
        }
    }
    
    $end = $start + 30;
    $btn = [];
    $bt = [];
    $count = -1;
    $a = 1;
    
    foreach ($get as $k => $p) {
        $count++;
        if ($count < $start) continue;
        if ($count >= $end) break;
        
        $status = isset($contries[$k]) ? "✅" : "❌";
        
        if ($a % 2 == 0) {
            $bt[] = ['text' => "{$names[$k]} | $p $status", 'callback_data' => "add#$k#$data"];
            $btn[] = $bt;
            $bt = [];
        } else {
            $bt[] = ['text' => "{$names[$k]} | $p $status", 'callback_data' => "add#$k#$data"];
        }
        $a++;
    }
    
    if (count($bt) > 0) $btn[] = $bt;
    
    $btn[] = [
        ['text' => ($adminLang == 'ar' ? "السابق ⏮️" : "Previous ⏮️"), 'callback_data' => "before#{$start}"],
        ['text' => ($adminLang == 'ar' ? "⏭️التالي" : "Next⏭️"), 'callback_data' => "next#{$end}"],
    ];
    $btn[] = [['text' => $backText, 'callback_data' => "back"]];
    
    edit($tx, $btn);
} else if ($exData[0] == "add") {
    $info[$id]['action'] = "addContry";
    $info[$id]['contry'] = $exData[1];
    DataManager::save("storage/data/info.json", $info);
    
    $tx = $translationManager->get("25", $adminLang);
    $btn = mkBtn([[$backText => $exData[2]]]);
    edit($tx, $btn);
} else if ($text && $info[$id]['action'] == "addContry") {
    if (is_numeric($text) && $text > 0) {
        $contries[$info[$id]['contry']] = $text;
        DataManager::save("storage/data/contries.json", $contries);
        
        $tx = $translationManager->get("26", $adminLang);
        $info[$id]['action'] = "";
        $info[$id]['contry'] = "";
        DataManager::save("storage/data/info.json", $info);
    } else {
        $tx = $translationManager->get("27", $adminLang);
    }
    send($tx, $back);
} else if ($data == "remContry" || $exData[0] == 'NEXT' || $exData[0] == 'BEFORE') {
    $tx = $translationManager->get("28", $adminLang);
    
    if ($data == "remContry") {
        $start = 0;
    } else if ($exData[0] == 'NEXT') {
        $start = $exData[1];
        if ($start > count($contries)) {
            bot('answercallbackquery', [
                'callback_query_id' => $update->callback_query->id,
                'show_alert' => true,
                'text' => $translationManager->get("23", $adminLang),
            ]);
            exit;
        }
    } else if ($exData[0] == 'BEFORE') {
        $start = $exData[1];
        if ($start >= 30) {
            $start -= 30;
        } else if ($start > 0) {
            $start = 0;
        } else {
            bot('answercallbackquery', [
                'callback_query_id' => $update->callback_query->id,
                'show_alert' => true,
                'text' => $translationManager->get("24", $adminLang),
            ]);
            exit;
        }
    }
    
    $end = $start + 30;
    $btn = [];
    $bt = [];
    $count = -1;
    $a = 0;
    
    foreach ($contries as $k => $p) {
        $count++;
        if ($count < $start) continue;
        if ($count >= $end) break;
        
        if ($a % 2 == 0) {
            $btn[] = $bt;
            $bt = [];
            $bt[] = ['text' => "{$names[$k]} | $p", 'callback_data' => "remove#$k"];
        } else {
            $bt[] = ['text' => "{$names[$k]} | $p", 'callback_data' => "remove#$k"];
        }
        $a++;
    }
    
    if (count($bt) > 0) $btn[] = $bt;
    
    $btn[] = [
        ['text' => ($adminLang == 'ar' ? "السابق ⏮️" : "Previous ⏮️"), 'callback_data' => "BEFORE#{$start}"],
        ['text' => ($adminLang == 'ar' ? "⏭️التالي" : "Next⏭️"), 'callback_data' => "NEXT#{$end}"],
    ];
    $btn[] = [['text' => $backText, 'callback_data' => "back"]];
    
    edit($tx, $btn);
} else if ($exData[0] == "remove") {
    $contries[$exData[1]] = null;
    unset($contries[$exData[1]]);
    DataManager::save("storage/data/contries.json", $contries);
    
    $tx = $translationManager->get("29", $adminLang);
    edit($tx, $back);
} else if ($data == "stats") {
    $a = $stats['all']['trybuy'] ?? 0;
    $b = $stats['all']['buy'] ?? 0;
    
    $tx = $translationManager->get("30", $adminLang, ["__trybuy__" => $a, "__buy__" => $b]);
    edit($tx, $back);
} else if ($data == "performance") {
    $performanceReport = $performanceMonitor->getPerformanceReport(24); // آخر 24 ساعة
    $systemStats = $performanceMonitor->getSystemStats();
    $asyncStats = $asyncProcessor->getQueueStats();
    
    $tx = "📊 " . $translationManager->get("31", $adminLang) . "\n\n";
    $tx .= "⏱ وقت التنفيذ المتوسط: " . $performanceReport['avg_execution_time'] . "ms\n";
    $tx .= "🧠 الذاكرة المستخدمة: " . $systemStats['memory_usage']['current'] . "\n";
    $tx .= "📈 كفاءة التخزين المؤقت: " . $performanceReport['cache_efficiency'] . "%\n";
    $tx .= "🔄 طلبات البوت: " . $performanceReport['total_bot_requests'] . "\n";
    $tx .= "🌐 طلبات API: " . $performanceReport['total_api_requests'] . "\n";
    $tx .= "📦 المهام في الطابور: " . $asyncStats['queue_size'] . "\n\n";
    
    if (!empty($performanceReport['slow_requests'])) {
        $tx .= "🐌 " . $translationManager->get("32", $adminLang) . ":\n";
        foreach (array_slice($performanceReport['slow_requests'], 0, 5) as $slowReq) {
            $tx .= "• " . $slowReq['execution_time'] . "ms - " . $slowReq['url'] . "\n";
        }
    }
    
    $btn = mkBtn([
        [$backText => "back"],
        ["تحديث ♻️" => "performance"]
    ]);
    
    edit($tx, $btn);
}
?>