<?php
// تم تعطيل الإبلاغ عن الأخطاء للاستخدام الإنتاجي
// error_reporting(0);

// تحميل الأنظمة الأساسية
require_once "core/AdvancedCache.php";
require_once "core/DataManager.php";
require_once "core/TranslationManager.php";
require_once "core/HighPerformanceApi.php";
require_once "core/AsyncProcessor.php";
require_once "core/PerformanceMonitor.php";

// تهيئة الأنظام
DataManager::init();
$performanceMonitor = PerformanceMonitor::getInstance();
$performanceMonitor->startRequest();

// تحميل الإعدادات
require_once "config/vals.php";
require_once "config/contries.php";

define('API_KEY', $token);

// وظائف البوت الأساسية
function bot($method, $datas = []) {
    $url = "https://api.telegram.org/bot" . API_KEY . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    
    $res = curl_exec($ch);
    
    // تسجيل الأخطاء فقط في حالة وجود خطأ
    if (curl_error($ch)) {
        file_put_contents('logs/error.txt', date('Y-m-d H:i:s') . " - " . curl_error($ch) . " - Method: $method" . PHP_EOL, FILE_APPEND);
        $result = json_decode($res);
    } else {
        $result = json_decode($res);
    }
    
    curl_close($ch);
    return $result;
}

$link = "https://".$_SERVER["SERVER_NAME"].$_SERVER["PHP_SELF"];
$setWebhook = file_get_contents("https://api.telegram.org/bot$token/setWebHook?url=$link");

function check_member($id, $chat) {
    $cache = AdvancedCache::getInstance();
    $cacheKey = "member_{$id}_{$chat}";
    
    if ($cached = $cache->get($cacheKey)) {
        return $cached;
    }
    
    $join = bot('getChatMember', ["chat_id" => $chat, "user_id" => $id])->result->status;
    $result = !($join == 'left' || $join == 'kicked');
    
    $cache->set($cacheKey, $result, 300); // تخزين مؤقت لمدة 5 دقائق
    return $result;
}

// دوال مساعدة محسنة
function mkBtn($btn) {
    $res = array();
    foreach ($btn as $d) {
        $r = array();
        foreach ($d as $k => $v) {
            $r[] = ['text' => $k, 'callback_data' => $v];
        }
        $res[] = $r;
    }
    return $res;
}

function send($text, $btn = null, $id = null) {
    if ($id == null) {
        global $id;
    }
    
    $data = array(
        'chat_id' => $id,
        'text' => $text,
        'parse_mode' => 'html'
    );
    
    if($btn != null){
        $data['reply_markup'] = json_encode(['inline_keyboard' => $btn]);
    }
    
    PerformanceMonitor::getInstance()->incrementMetric('bot_requests');
    return bot('sendMessage', $data);
}

function edit($text, $btn = null) {
    global $id, $message_id;
    
    $data = array(
        'chat_id' => $id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'html'
    );
    
    if($btn != null){
        $data['reply_markup'] = json_encode(['inline_keyboard' => $btn]);
    }
    
    PerformanceMonitor::getInstance()->incrementMetric('bot_requests');
    return bot('editMessageText', $data);
}

// معالجة البيانات الواردة
$update = json_decode(file_get_contents('php://input'));

if ($update->message) {
    $message = $update->message;
    $chat_id = $message->chat->id;
    $text = $message->text;
    $ex = explode(" ", $text);
    $first_name = $update->message->from->first_name;
    $username = $message->from->username;
    $id = $message->from->id;
    $message_id = $message->message_id;
    $language_code = $message->from->language_code;
    $tc = $update->message->chat->type;
} else if ($update->callback_query) {
    $chat_id = $update->callback_query->message->chat->id;
    $id = $update->callback_query->from->id;
    $first_name = $update->callback_query->from->first_name;
    $message_id = $update->callback_query->message->message_id;
    $data = $update->callback_query->data;   
    $exData = explode("#", $data); 
} else {
    exit;
}

// تحميل البيانات مع التخزين المؤقت
$points = DataManager::load("storage/data/points.json");
$stats = DataManager::load("storage/data/stats.json");
$op = DataManager::load("storage/data/operations.json");
$invite = DataManager::load("storage/data/invites.json");
$bans = DataManager::load("storage/data/bans.json");
$info = DataManager::load("storage/data/info.json");
$contries = DataManager::load("storage/data/contries.json");
$langs = DataManager::load("storage/data/langs.json");

$point = $points[$id] ?? 0;

// تهيئة API عالي الأداء
$api = new HighPerformanceApi($api_key);

// تحميل الواجهة المناسبة
if ($id == $admin) {
    $balance = $api->getBalance() ?? 0;
    require "admin.php";
} else {
    require "member.php";
}

// تسجيل أداء الطلب
$performanceData = $performanceMonitor->endRequest();
if ($performanceData['execution_time'] > 1000) { // إذا تجاوز الثانية
    file_put_contents('logs/slow_requests.log', 
        date('Y-m-d H:i:s') . " - Slow Request: " . 
        json_encode($performanceData) . PHP_EOL, 
        FILE_APPEND
    );
}
?>